#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;

#endregion

namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_CprsOrgMessage : BaseTest
	{
		private const string TAS_TEST_ORDER = "1^TAS^99VBC^^";
		private const string KC_DIVISION = "589^VA HEARTLAND - WEST, VISN 15";


		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}
		[TearDown]
		protected void TearDown()
		{
		}

		[Test]
		public void AckError_Pass()
		{
			int orderNum = HL7ALUnitTestUtility.GetRandomNumber(9999);
			int orderGroupNum = orderNum + 1;
			HL7OmgMessage msg = new HL7OmgMessage(HL7ALUnitTestUtility.GetCprsMessage("NW",orderNum.ToString(),orderGroupNum.ToString(),TAS_TEST_ORDER,KC_DIVISION,HL7ALUnitTestUtility.GetRandomNumber(999999).ToString()));

			Assert.IsNotNull(CprsOrgMessage.AckError(msg,AckCodes.AE,"Unit Testing"));
		}

		[Test]
		[ExpectedException( typeof ( ArgumentNullException ) )]
		public void AckError_Fail_1()
		{
			HL7OrgMessage msg = CprsOrgMessage.AckError( null, AckCodes.AE, "Unit Test AckError method");
		}

		[Test]
		public void AppAcceptAck_Pass()
		{
			int orderNum = HL7ALUnitTestUtility.GetRandomNumber(9999);
			int orderGroupNum = orderNum + 1;
			HL7OmgMessage msg = new HL7OmgMessage(HL7ALUnitTestUtility.GetCprsMessage("NW",orderNum.ToString(),orderGroupNum.ToString(),TAS_TEST_ORDER,KC_DIVISION,HL7ALUnitTestUtility.GetRandomNumber(999999).ToString()));

			Assert.IsNotNull(CprsOrgMessage.AppAcceptAck(msg,OrderControlCodes.OK,HL7ALUnitTestUtility.GetRandomNumber(9999)));
		}

		[Test]
		[ExpectedException( typeof ( ArgumentNullException ) )]
		public void AppAcceptAck_Fail_1()
		{
			HL7OrgMessage msg = CprsOrgMessage.AppAcceptAck(null,OrderControlCodes.OK,HL7ALUnitTestUtility.GetRandomNumber(9999));
		}



	}
}
#endif
